/* - IRAttachListener -
 * populate the fields and controls
 *
 * Copyright 2011 Phidgets Inc.
 * This work is licensed under the Creative Commons Attribution 2.5 Canada License.
 * To view a copy of this license, visit http://creativecommons.org/licenses/by/2.5/ca/
 */
package listeners;

import com.phidgets.IRPhidget;
import com.phidgets.PhidgetException;
import com.phidgets.event.AttachListener;
import com.phidgets.event.AttachEvent;

import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class IRAttachListener implements AttachListener {

    private JFrame appFrame;
    private JPanel codePanel;
    private JPanel learnPanel;
    private JPanel rawDataPanel;
    private JTextField attachedTxt;
    private JTextArea nameTxt;
    private JTextField serialTxt;
    private JTextField versionTxt;

    public IRAttachListener(JFrame appFrame, JPanel codePanel, JPanel learnPanel, JPanel rawDataPanel, JTextField attachedTxt, JTextArea nameTxt,
            JTextField serialTxt, JTextField versionTxt)  {
        this.appFrame = appFrame;
        this.codePanel = codePanel;
        this.learnPanel = learnPanel;
        this.rawDataPanel = rawDataPanel;
        this.attachedTxt = attachedTxt;
        this.nameTxt = nameTxt;
        this.serialTxt = serialTxt;
        this.versionTxt = versionTxt;
     }

    public void attached(AttachEvent an) {
        try {

            appFrame.setSize(737, 720);

            IRPhidget attached = (IRPhidget) an.getSource();
            attachedTxt.setText(Boolean.toString(attached.isAttached()));
            nameTxt.setText(attached.getDeviceName());
            serialTxt.setText(Integer.toString(attached.getSerialNumber()));
            versionTxt.setText(Integer.toString(attached.getDeviceVersion()));
          
            codePanel.setEnabled(true);
            codePanel.setVisible(true);

            learnPanel.setEnabled(true);
            learnPanel.setVisible(true);

            rawDataPanel.setEnabled(true);
            rawDataPanel.setVisible(true);

        } catch (PhidgetException ex) {
            JOptionPane.showMessageDialog(appFrame, ex.getDescription(), "Phidget error " + ex.getErrorNumber(), JOptionPane.ERROR_MESSAGE);
        }
    }
}
